#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin		= mxGetPr(prhs[0]);
    double *xss 	= mxGetPr(prhs[1]);
    double *yss 	= mxGetPr(prhs[2]);
	double *parmin 	= mxGetPr(prhs[3]);
	double *nnuin 	= mxGetPr(prhs[4]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];


	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n,n,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n,n,mxREAL);
	double *A_sp_s = mxGetPr(plhs[0]);
	double *B_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	A_sp_s[168]=pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho);
	A_sp_s[49]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	A_sp_s[73]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	A_sp_s[97]=-(pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	A_sp_s[50]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	A_sp_s[74]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	A_sp_s[75]=-((bbeta*pow(E,yss[8])*rrho*rrhoz*(1 + yss[5]))/pow(zbar,rrho));
	A_sp_s[387]=(bbeta*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho);
	A_sp_s[4]=pow(E,yss[8])*(-(abar*bbeta*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha - rrho)) + iiota*(zbar + bbeta*pow(zbar,2 - rrho)));
	A_sp_s[52]=-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha - rrho));
	A_sp_s[76]=pow(E,yss[8])*((bbeta*rrhoz*(rrho - ddelta*rrho - abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(aalpha - rrho)*pow(zbar,aalpha)))/pow(zbar,rrho) + iiota*(zbar - bbeta*rrhoz*pow(zbar,2 - rrho)));
	A_sp_s[220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho));
	A_sp_s[244]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha - rrho);
	A_sp_s[292]=-(bbeta*pow(E,yss[8])*iiota*pow(zbar,2 - rrho));
	A_sp_s[388]=(bbeta*pow(E,yss[8])*(-1 + ddelta - abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)))/pow(zbar,rrho);
	A_sp_s[5]=iiota*zbar;
	A_sp_s[77]=iiota*zbar;
	A_sp_s[31]=-(zbar/(1 + yss[5]));
	A_sp_s[55]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	A_sp_s[79]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]);
	A_sp_s[103]=-(pow(E,yss[2])*pbar*(1 + pphi*yss[5]));
	A_sp_s[151]=-(pow(E,yss[11])*ebar);
	A_sp_s[8]=-(pow(E,xss[0])*zbar);
	A_sp_s[80]=-(pow(E,xss[0])*zbar);
	A_sp_s[9]=pow(E,xss[0])*kkappa*zbar;
	A_sp_s[33]=zbar/(1 + yss[5]);
	A_sp_s[81]=pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]);
	A_sp_s[105]=-(pow(E,yss[2])*pbar*pphi*(1 + yss[5]));
	A_sp_s[35]=-(pow(E,bbar - xss[1])*ppsir);
	A_sp_s[131]=1;
	A_sp_s[12]=pow(E,xss[0]);
	A_sp_s[61]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	A_sp_s[85]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	A_sp_s[109]=pow(E,yss[2])*pbar;
	A_sp_s[38]=-(zbar/pow(E,yss[11]));
	A_sp_s[86]=-((zbar*xss[1])/pow(E,yss[11]));
	A_sp_s[39]=-(zbar/pow(E,yss[11]));
	A_sp_s[87]=-((zbar*xss[1])/pow(E,yss[11]));
	A_sp_s[160]=ebar;
	A_sp_s[89]=-((rrho*rrhoz*pow(zbar,rrho)*yss[9])/(bbeta*pow(E,yss[8])));
	A_sp_s[401]=(pow(zbar,rrho)*yss[9])/(bbeta*pow(E,yss[8]));
	A_sp_s[66]=-1;
	A_sp_s[91]=-1;
	A_sp_s[116]=-1;
	A_sp_s[189]=-1;
	A_sp_s[166]=-1;
	A_sp_s[143]=-1;
	B_sp_s[192]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho);
	B_sp_s[216]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho;
	B_sp_s[384]=-pow(E,yss[8]);
	B_sp_s[1]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	B_sp_s[217]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	B_sp_s[241]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha);
	B_sp_s[313]=-((pbar*pphi*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	B_sp_s[385]=(pbar*pphi*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	B_sp_s[409]=-((pbar*pphi*(1 + yss[5]))/pow(E,yss[8]));
	B_sp_s[2]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha);
	B_sp_s[218]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	B_sp_s[242]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha);
	B_sp_s[314]=-(pow(E,yss[7] - yss[8])*pphi*(pow(E,yss[8]) + yss[9]));
	B_sp_s[362]=-(pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	B_sp_s[386]=pow(E,yss[7] - yss[8])*pphi*(1 + yss[5])*yss[9];
	B_sp_s[410]=-(pow(E,yss[7] - yss[8])*pphi*(1 + yss[5]));
	B_sp_s[315]=(bbeta*pow(E,yss[8]))/pow(zbar,rrho);
	B_sp_s[387]=-pow(E,yss[8]);
	B_sp_s[411]=1;
	B_sp_s[4]=-(pow(E,yss[8])*iiota*zbar);
	B_sp_s[340]=-(kkappa*yss[9]);
	B_sp_s[388]=pow(E,yss[8]);
	B_sp_s[412]=-kkappa;
	B_sp_s[5]=-(iiota*zbar);
	B_sp_s[341]=-1;
	B_sp_s[222]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega);
	B_sp_s[366]=-pow(E,yss[7]);
	B_sp_s[7]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha);
	B_sp_s[31]=1;
	B_sp_s[199]=-pow(E,yss[0]);
	B_sp_s[223]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5];
	B_sp_s[247]=pow(E,yss[2])*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	B_sp_s[271]=-pow(E,yss[3]);
	B_sp_s[319]=-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2);
	B_sp_s[367]=-(pow(E,yss[1] + yss[7])*pphi*yss[5]);
	B_sp_s[8]=-((-1 + ddelta)*pow(E,xss[0]));
	B_sp_s[272]=pow(E,yss[3]);
	B_sp_s[225]=-(pow(E,yss[1] + yss[7])*pphi*(1 + yss[5]));
	B_sp_s[249]=-(pow(E,yss[2])*pbar*pphi*(1 + yss[5]));
	B_sp_s[321]=-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2);
	B_sp_s[345]=pow(E,xss[0])*kkappa*zbar;
	B_sp_s[369]=-(pow(E,yss[1] + yss[7])*pphi*(1 + yss[5]));
	B_sp_s[441]=-1;
	B_sp_s[418]=-1 + nnus;
	B_sp_s[442]=nnus;
	B_sp_s[323]=-1;
	B_sp_s[300]=-pow(E,xss[0]);
	B_sp_s[13]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha));
	B_sp_s[229]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	B_sp_s[253]=pow(E,yss[2])*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	B_sp_s[469]=pow(E,yss[11]);
	B_sp_s[470]=(zbar*xss[1])/pow(E,yss[11]);
	B_sp_s[494]=1;
	B_sp_s[39]=pow(E,-yss[11]);
	B_sp_s[471]=((-1 + zbar)*xss[1])/pow(E,yss[11]);
	B_sp_s[519]=1;
	B_sp_s[208]=pow(E,yss[0] - yss[11]);
	B_sp_s[280]=pow(E,yss[3] - yss[11]);
	B_sp_s[472]=-((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)/pow(E,yss[11]));
	B_sp_s[544]=1;
	B_sp_s[425]=-(pow(zbar,rrho)/(bbeta*pow(E,yss[8])));
	B_sp_s[569]=1;
	B_sp_s[66]=rrhoa;
	B_sp_s[91]=rrhoz;
	B_sp_s[116]=rrhop;
	B_sp_s[189]=rrhod;
	B_sp_s[166]=rrhoe;
	B_sp_s[143]=rrhor;

}
